<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Database\QueryException;
use Illuminate\Support\Facades\DB;
use App\Models\Product;
use App\Models\Post;
use App\Models\DailyUpdate;
use App\Models\DailyUpdateCategory;
use App\Models\Attribute;
use App\Models\Grade;

use App\Http\Resources\DailyUpdate as DailyUpdateCollection;
use App\Http\Resources\Product as ProductCollection;
use App\Http\Resources\Post as PostCollection;
use App\Http\Resources\DailyUpdateCategory as DailyUpdateCategoryCollection;
use App\Http\Resources\Attribute as AttributeCollection;
use App\Http\Resources\Grade as GradeCollection;

class PageController extends Controller
{
    public function home(Request $request){
        try{
            $box = Product::where('status', 1)
            ->whereIn('display_box', [1, 2, 3, 4, 5, 6])
            ->orderBy('id')
            ->get()
            ->unique('display_box');

            $news = DailyUpdate::where('status', 1)
            ->orderBy('created_at', 'desc')
            ->limit(6)
            ->get();

            $post = Post::orderBy('created_at', 'desc')
            ->limit(8)
            ->get();

            return response()->json(['box_product' => ProductCollection::collection($box), 
            'news_data' => DailyUpdateCollection::collection($news),
            'post_data' => PostCollection::collection($post)
        ], 200);

        }catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }

    public function latestNews(Request $request){
        try{
            $data = DailyUpdate::where('status',1)->orderBy('created_at','desc')->first();

            return response()->json(['record' => new DailyUpdateCollection($data)], 200);

        }catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }


    public function newsCategory(Request $request){
        try{
            $data = DailyUpdateCategory::where('status',1)->get();

            return response()->json(['records' => DailyUpdateCategoryCollection::collection($data)], 200);

        }catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }


    public function newsData(Request $request)
    {
        try {
            $limit = $request->query('limit', 10);
                $query = DailyUpdate::query();
                // Get all parameters from the request
                $parameters = $request->all();

                // Loop through each parameter and apply filters to the query
                foreach ($parameters as $key => $value) {
                    // Make sure the key is not a reserved Laravel parameter
                    if ($key !== 'page' && $key !== 'limit') {
                        $query->where($key, $value);
                    }
                }
                $dailyupdates = $query->orderBy('updated_at', 'desc')->paginate($limit);
                
                $dailyupdateCollection = DailyUpdateCollection::collection($dailyupdates->items());

                $responseData = [
                    'records' => $dailyupdateCollection,
                    'pagination' => [
                        'current_page' => $dailyupdates->currentPage(),
                        'last_page' => $dailyupdates->lastPage(),
                        'per_page' => $dailyupdates->perPage(),
                        'total' => $dailyupdates->total(),
                    ],
                ];
                
            return response()->json($responseData);
        } catch (QueryException $e) {
            return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
        } catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }

    public function singleNews(Request $request,$slug)
    {
        try {
            $data = DailyUpdate::where('dailyupdate_slug',$slug)->first();

            return response()->json(['record' => new DailyUpdateCollection($data)], 200);
        } catch (QueryException $e) {
            return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
        } catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }


    // Steel Spesification

    public function activeAttribute(Request $request)
    {
        try {
            $attribute = Attribute::where('status',true)->orderBy('id')->get();

            return response()->json(['records' => AttributeCollection::collection($attribute)]);
        } catch (QueryException $e) {
            return response()->json(['message' => 'Database error: ' . $e->getMessage()], 500);
        } catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }

    public function specificationData(Request $request, $id){
        try{
            $specification = Grade::findOrFail($id);
            return response()->json(['message' => 'Specification Details Fetached successfully', 'record' => new GradeCollection($specification)], 200);
        }catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }

    public function specification(Request $request){
        try{
            $specification = Grade::where('status',1)->get();
            return response()->json(['message' => 'Specification Details Fetached successfully', 'records' => GradeCollection::collection($specification)], 200);
        }catch (\Exception $e) {
            return response()->json(['message' => 'An unexpected error occurred: ' . $e->getMessage()], 500);
        }
    }



    
    
}