<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Advertisement extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'advertisement_name' => $this->advertisement_name,
            'advertisement_block' => $this->advertisement_block,
            'advertisement_description' => $this->advertisement_description,
            'start_at' => date("d/m/Y", strtotime($this->start_at)),
            'expires_at' => date("d/m/Y", strtotime($this->expires_at)),
            'advertisement_url' => $this->advertisement_url,
            'advertisement_image_id' => $this->advertisement_image_id,
            'advertisement_slider_image_id' => $this->advertisement_slider_image_id,
            'advertisement_image' => $this->media_image ? url(Storage::url($this->media_image->webp_path)) : null,
            'advertisement_slider' => Media::collection($this->media_slider()),
            'status' => $this->status
        ];
    }
}