<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Article extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'article_title' => $this->article_title,
            'article_content' => $this->article_content,
            'image_id' => $this->image_id,
            'user_id' => $this->user_id,
            'user' => new Customer($this->user),
            'status' => $this->status,
            'is_publish' => $this->is_publish,
            'article_image' => $this->image ? url(Storage::url($this->image->webp_path)) : null,
            'article_thumb_image' => $this->image ? url(Storage::url($this->image->thumb_path)) : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
           // 'uploaded_on' => Carbon::createFromFormat('d/m/Y', $this->created_at)->format('M, d Y'), 
        ];
    }
}
