<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class Category extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $array = [
            'id' => $this->id,
            'category_name' => $this->category_name,
            'product_name' => $this->product_data ? $this->product_data->product_name : 'anonymous',
            'product_id' => $this->product_id,
            'is_child' => $this->is_child,
            'parent_id' => $this->parent_id,
            'status' => $this->status,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
        
        if (!$this->children->isEmpty()) {
            $array['children'] = Category::collection($this->children);
        }
        
        return $array;
    }
}
