<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;
use Carbon\Carbon;

class DailyUpdate extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'dailyupdate_name' => $this->dailyupdate_name,
            'dailyupdate_description' => $this->dailyupdate_description,
            'dailyupdate_slug' => $this->dailyupdate_slug,
            'dailyupdate_category_id' => $this->dailyupdate_category_id,
            'dailyupdate_image_id' => $this->dailyupdate_image_id,
            'status' => $this->status,
            'category_name' => $this->category ? $this->category->dailyupdatecategory_name : 'anonymous',
            'post_image' => $this->post_image ? url(Storage::url($this->post_image->webp_path)) : null,
            'post_thumb_image' => $this->post_image ? url(Storage::url($this->post_image->thumb_path)) : null,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
           // 'uploaded_on' => Carbon::createFromFormat('d/m/Y', $this->created_at)->format('M, d Y'), 
        ];
    }
}


