<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Manager extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'role' => $this->role,
            'status' => $this->status,
            'profile_pic_id' => $this->manager->profile_pic_id,
            'profile_image' => $this->manager->profile_pic ? url(Storage::url($this->manager->profile_pic->webp_path)) : null,
            'role_id' => $this->manager->role_id,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}
