<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Post extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        $productData = new Product($this->product);
        return [
            'id' => $this->id,
            'product' => $productData,
            'category' => $this->category,
            'city' => $this->city,
            'grade' => $this->grade,
            'user' => new Customer($this->user),
            'product_id' => $this->product_id,
            'category_id' => $this->category_id,
            'city_id' => $this->city_id,
            'grade_id' => $this->grade_id,
            'user_id' => $this->user_id,
            'name' => $this->name,
            'email' => $this->email,
            'phone' => $this->phone,
            'cover_letter' => $this->cover_letter,
            'experience' => $this->experience,
            'title' => $this->title,
            'shape' => $this->shape,
            'segment' => $this->segment,
            'stock_type' => $this->stock_type,
            'qty_unit' => $this->qty_unit,
            'size_unit' => $this->size_unit,
            'qty' => $this->qty,
            'size' => $this->size,
            'description' => $this->description,
            'address' => $this->address,
            'status' => $this->status,
            'image_id' => $this->image_id,
            'other_image_id' => $this->other_image_id == '[]' ? null : $this->other_image_id,
            'cv_id' => $this->cv_id,            
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
            'image' => $this->post_image ? url(Storage::url($this->post_image->webp_path)) : url(Storage::url($productData->product_image->webp_path)),
        ];
    }
}
