<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\URL;

class Product extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'product_name' => $this->product_name,
            'fields' => $this->fields($this->id),
            'display_box' => $this->display_box,
            'product_type' => $this->product_type,
            'product_description' => $this->product_description,
            'product_image_id' => $this->product_image_id,
            'product_image' => $this->product_image ? url(Storage::url($this->product_image->webp_path)) : null,
            'product_thumb_image' => $this->product_image ? url(Storage::url($this->product_image->thumb_path)) : null,
            'status' => $this->status,
            'category' => Category::collection($this->product_category),
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at
        ];
    }
}