<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Advertisement extends Model
{
    use HasFactory;
    protected $fillable = [
        'advertisement_name',
        'advertisement_block',
        'advertisement_description',
        'start_at',
        'expires_at',
        'advertisement_url',
        'status',
        'advertisement_image_id',
        'advertisement_slider_image_id',
    ];

    protected $casts = [
        'advertisement_slider_image_id' => 'array',
    ];

    public function media_slider()
    {
        return Media::whereIn('id', $this->advertisement_slider_image_id)->get();
    }

    public function media_image()
    {
        return $this->belongsTo(Media::class, 'advertisement_image_id', 'id');
    }


    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }
}