<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Article extends Model
{
    use HasFactory;
    protected $fillable = [
        'article_title',
        'article_content',
        'is_publish',
        'user_id',
        'image_id',
        'status'
    ];



    public function image()
    {
        return $this->belongsTo(Media::class, 'image_id');
    }

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }
}
