<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Post extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_id',
        'category_id',
        'city_id',
        'grade_id',
        'user_id',
        'name',
        'email',
        'phone',
        'cover_letter',
        'experience',
        'title',
        'shape',
        'shape',
        'stock_type',
        'qty_unit',
        'size_unit',
        'qty',
        'size',
        'description',
        'address',
        'status',
        'image_id',
        'other_image_id',
        'cv_id'
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function grade()
    {
        return $this->belongsTo(Grade::class);
    }

    public function post_image()
    {
        return $this->belongsTo(Media::class,'image_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }
}
