<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Product extends Model
{
    use HasFactory;
    protected $fillable = [
        'product_name',
        'group_id',
        'product_description',
        'status',
        'product_image_id',
        'product_type',
        'display_box'
    ];

    public function product_image()
    {
        return $this->belongsTo(Media::class, 'product_image_id');
    }

    public function product_field()
    {
        return $this->hasMany(ProductField::class, 'product_id');
    }

    public function product_category()
    {
        return $this->hasMany(Category::class, 'product_id')->where('is_child', 0);
    }

    public function fields($id){
        return ProductField::where('product_id',$id)->pluck('field');
    }

    public function group_data()
    {
        return $this->belongsTo(ProductGroup::class, 'group_id');
    }

    public function getCreatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }

    // Accessor to format the updated_at field
    public function getUpdatedAtAttribute($value)
    {
        return \Carbon\Carbon::parse($value)->format('d/m/Y H:i a');
    }
}