<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('daily_updates', function (Blueprint $table) {
            $table->id();
            $table->string('dailyupdate_name');
            $table->text('dailyupdate_description');
            $table->string('dailyupdate_slug')->unique();
            $table->unsignedBigInteger('dailyupdate_category_id');
            $table->unsignedBigInteger('dailyupdate_image_id');
            $table->boolean('status');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('daily_updates');
    }
};
