<?php

namespace App\Http\Controllers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;




// Admin Side Api
Route::group(['prefix' => 'v1/backend'], function () {

    Route::get('customer/counter',  [CustomerController::class, 'customerCounter']);


    Route::prefix('price')->group(function () {
        Route::get('/close/today',  [PriceController::class, 'todayClosePrice']);
    });

    Route::prefix('post')->group(function () {
        Route::get('/anonymous/post/data',  [PostController::class, 'getAnonymous']);
    });

    Route::prefix('price/mobile')->group(function () {
        Route::get('/product/{id}',  [PriceController::class, 'todayPriceByProduct']);
    });
    Route::prefix('product')->group(function () {
        Route::get('/open/active',  [ProductController::class, 'activeProduct']);

    });

   

    Route::get('/home', [PageController::class, 'home']);

    Route::get('/latest-news', [PageController::class, 'latestNews']);
    Route::get('/news/category', [PageController::class, 'newsCategory']);
    Route::get('/news', [PageController::class, 'newsData']);
    Route::get('/news/{slug}', [PageController::class, 'singleNews']);


    // Get specification data

    Route::get('specification-attrtibute',[PageController::class, 'activeAttribute']);
    Route::get('specification-data/{id}',[PageController::class, 'specificationData']);
    Route::get('specification-data',[PageController::class, 'specification']);





    // Authentication
    Route::post('/login',  [ManagerAuthenticationController::class, 'emailLogin']);
    //Route::post('/email-login',  [ManagerAuthenticationController::class, 'emailLogin']);
    Route::post('/send-otp',  [ManagerAuthenticationController::class, 'otpSend']);
    Route::post('/verify-otp',  [ManagerAuthenticationController::class, 'verifyOtp']);


    // Authentication
    Route::post('/customer/login',  [CustomerAuthenticationController::class, 'emailLogin']);
    //Route::post('/email-login',  [CustomerAuthenticationController::class, 'emailLogin']);
    Route::post('/customer/send-otp',  [CustomerAuthenticationController::class, 'otpSend']);
    Route::post('/customer/verify-otp',  [CustomerAuthenticationController::class, 'verifyOtp']);
});


Route::group(['prefix' => 'v1/front'], function () {

    Route::get('customer/counter',  [CustomerController::class, 'customerCounter']);


    Route::prefix('price')->group(function () {
        Route::get('/close/today',  [PriceController::class, 'todayClosePrice']);
    });

    Route::prefix('post')->group(function () {
        Route::get('/anonymous/post/data',  [PostController::class, 'getAnonymous']);
    });

    Route::prefix('price/mobile')->group(function () {
        Route::get('/product/{id}',  [PriceController::class, 'todayPriceByProduct']);
    });
    Route::prefix('product')->group(function () {
        Route::get('/open/active',  [ProductController::class, 'activeProduct']);

    });

   

    Route::get('/home', [PageController::class, 'home']);

    Route::get('/latest-news', [PageController::class, 'latestNews']);
    Route::get('/news/category', [PageController::class, 'newsCategory']);
    Route::get('/news', [PageController::class, 'newsData']);
    Route::get('/news/{slug}', [PageController::class, 'singleNews']);


    // Get specification data

    Route::get('specification-attrtibute',[PageController::class, 'activeAttribute']);
    Route::get('specification-data/{id}',[PageController::class, 'specificationData']);
    Route::get('specification-data',[PageController::class, 'specification']);


    // Authentication
    Route::post('/customer/login',  [CustomerAuthenticationController::class, 'emailLogin']);
    //Route::post('/email-login',  [CustomerAuthenticationController::class, 'emailLogin']);
    Route::post('/customer/send-otp',  [CustomerAuthenticationController::class, 'otpSend']);
    Route::post('/customer/verify-otp',  [CustomerAuthenticationController::class, 'verifyOtp']);
});








Route::group(['prefix' => 'v1/front', 'middleware' => ['auth:sanctum']], function () {


    Route::prefix('state')->group(function () {

        // Getting data
        Route::get('/',  [StateController::class, 'index']);

    });

    Route::prefix('city')->group(function () {

        // Getting data
      
        Route::get('/{id}', [CityController::class, 'byState']);
    });


    Route::prefix('price')->group(function () {
        Route::get('/today/header',  [PriceController::class, 'todayPrice']);
    });

    Route::get('/customer/logout',  [CustomerAuthenticationController::class, 'logout']);


    Route::get('/user', function (Request $request) {
        return $request->user();
    });

    Route::prefix('specification')->group(function () {

        // CRUD operations
        Route::post('/',  [SpecificationController::class, 'store']);
        Route::get('/',  [SpecificationController::class, 'index']);
        Route::get('/{id}',  [SpecificationController::class, 'show']);
        Route::put('/{id}',  [SpecificationController::class, 'update']);
        Route::delete('/{id}',  [SpecificationController::class, 'destroy']);
    });


    Route::prefix('grade')->group(function () {

        //other Opreation
        Route::get('/active',  [GradeController::class, 'activeGrade']);
        
        // CRUD operations
       Route::post('/',  [GradeController::class, 'store']);
       Route::get('/',  [GradeController::class, 'index']);
       Route::get('/{id}',  [GradeController::class, 'show']);
       Route::put('/{id}',  [GradeController::class, 'update']);
       Route::delete('/{id}',  [GradeController::class, 'destroy']);

   });

   Route::prefix('customer')->group(function () {
    // Other operations
    Route::post('/profile-pic',  [CustomerController::class, 'profilePic']);
    Route::post('/cover-pic',  [CustomerController::class, 'coverPic']);
    Route::get('/profile',  [CustomerController::class, 'showProfile']);
    Route::put('/profile',  [CustomerController::class, 'updateProfile']);
    

    // CRUD operations
    Route::post('/',  [CustomerController::class, 'store']);
    Route::get('/',  [CustomerController::class, 'index']);
    Route::get('/{id}',  [CustomerController::class, 'show']);
    Route::put('/{id}',  [CustomerController::class, 'update']);
    Route::delete('/{id}',  [CustomerController::class, 'destroy']);

});






});



Route::group(['prefix' => 'v1/front', 'middleware' => ['auth:sanctum', \App\Http\Middleware\ProfileCompletionCheck::class]], function () {

    Route::prefix('price')->group(function () {
        Route::get('/today',  [PriceController::class, 'todayPrice']);
        Route::get('/single',  [PriceController::class, 'getpriceProductCity']);

      
        Route::post('/',  [PriceController::class, 'store']);
        Route::get('/',  [PriceController::class, 'index']);
        Route::get('/{id}',  [PriceController::class, 'show']);
        Route::put('/{id}',  [PriceController::class, 'update']);
        Route::delete('/{id}',  [PriceController::class, 'destroy']);
    });

    Route::prefix('post')->group(function () {
        Route::post('/',  [PostController::class, 'store']);
        Route::get('/',  [PostController::class, 'index']);
        Route::get('/{id}',  [PostController::class, 'show']);
        Route::put('/{id}',  [PostController::class, 'update']);
        Route::delete('/{id}',  [PostController::class, 'destroy']);
    });



    // Media Upload
    Route::prefix('media')->group(function () {

        // Other oprateions
        Route::post('/selected',  [MediaController::class, 'selectedImage']);

        // CRUD operations
        Route::get('/',  [MediaController::class, 'index']);
        Route::post('/',  [MediaController::class, 'upload']);
        Route::get('/{id}',  [MediaController::class, 'show']);
        Route::delete('/{id}',  [MediaController::class, 'delete']);
    });

    // Product
    Route::prefix('product')->group(function () {
        Route::get('/active',  [ProductController::class, 'activeProduct']);
        
        // CRUD operations
        Route::post('/',  [ProductController::class, 'store']);
        Route::get('/',  [ProductController::class, 'index']);
        Route::get('/{id}',  [ProductController::class, 'show']);
        Route::put('/{id}',  [ProductController::class, 'update']);
        Route::delete('/{id}',  [ProductController::class, 'destroy']);
    });


    // Specifications
    


    // Attribute
    Route::prefix('attribute')->group(function () {
        //other Opreation
        Route::get('/active',  [AttributeController::class, 'activeAttribute']);

         // CRUD operations
        Route::post('/',  [AttributeController::class, 'store']);
        Route::get('/',  [AttributeController::class, 'index']);
        Route::get('/{id}',  [AttributeController::class, 'show']);
        Route::put('/{id}',  [AttributeController::class, 'update']);
        Route::delete('/{id}',  [AttributeController::class, 'destroy']);

    });


    // Category
    Route::prefix('category')->group(function () {
        // Other operations
        Route::get('/parent', [CategoryController::class, 'parent']);
        Route::get('/product/{id}', [CategoryController::class, 'productCategory']);

        // CRUD operations
        Route::post('/', [CategoryController::class, 'store']);
        Route::get('/', [CategoryController::class, 'index']);
        Route::get('/{id}', [CategoryController::class, 'show']);
        Route::put('/{id}', [CategoryController::class, 'update']);
        Route::delete('/{id}', [CategoryController::class, 'destroy']);
        
        
    });

    // Advertisement
   

    // Daily update category
    Route::prefix('dailyupdates/category')->group(function () {
        // Other operations
        Route::get('/active',  [DailyUpdateCategoryController::class, 'activeCategory']);
        
        // CRUD operations 
        Route::post('/',  [DailyUpdateCategoryController::class, 'store']);
        Route::get('/',  [DailyUpdateCategoryController::class, 'index']);
        Route::get('/{id}',  [DailyUpdateCategoryController::class, 'show']);
        Route::put('/{id}',  [DailyUpdateCategoryController::class, 'update']);
        Route::delete('/{id}',  [DailyUpdateCategoryController::class, 'destroy']);
    });

     // Daily Update
     Route::prefix('dailyupdate')->group(function () {
        // Other operations

        // CRUD operations 
        Route::post('/',  [DailyUpdateController::class, 'store']);
        Route::get('/',  [DailyUpdateController::class, 'index']);
        Route::get('/{id}',  [DailyUpdateController::class, 'show']);
        Route::put('/{id}',  [DailyUpdateController::class, 'update']);
        Route::delete('/{id}',  [DailyUpdateController::class, 'destroy']);
    });

     // Article
     Route::prefix('article')->group(function () {
        // Other operations
        Route::post('/public',  [ArticleController::class, 'publishArticle']);

        // CRUD operations 
        Route::post('/',  [ArticleController::class, 'store']);
        Route::get('/',  [ArticleController::class, 'index']);
        Route::get('/{id}',  [ArticleController::class, 'show']);
        Route::put('/{id}',  [ArticleController::class, 'update']);
        Route::delete('/{id}',  [ArticleController::class, 'destroy']);
    });

    // Customer
    


    // Customer Type
    Route::prefix('customer-type')->group(function () {

        // CRUD operations
        Route::post('/',  [CustomerTypeController::class, 'store']);
        Route::get('/',  [CustomerTypeController::class, 'index']);
        Route::get('/{id}',  [CustomerTypeController::class, 'show']);
        Route::put('/{id}',  [CustomerTypeController::class, 'update']);
        Route::delete('/{id}',  [CustomerTypeController::class, 'destroy']);
    });


    Route::prefix('city')->group(function () {

        // Getting data
      
        Route::get('/', [CityController::class, 'index']);
    });




    Route::prefix('price/city')->group(function () {
        Route::get('/active/{id}',  [PriceCityController::class, 'activePriceCity']);
        // Getting data
      
        Route::post('/',  [PriceCityController::class, 'store']);
        Route::get('/',  [PriceCityController::class, 'index']);
        Route::get('/{id}',  [PriceCityController::class, 'show']);
        Route::put('/{id}',  [PriceCityController::class, 'update']);
        Route::delete('/{id}',  [PriceCityController::class, 'destroy']);
    });


    Route::prefix('price/state')->group(function () {
        Route::get('/active/{id}',  [PriceStateController::class, 'activePriceState']);
        // Getting data
      
        Route::post('/',  [PriceStateController::class, 'store']);
        Route::get('/',  [PriceStateController::class, 'index']);
        Route::get('/{id}',  [PriceStateController::class, 'show']);
        Route::put('/{id}',  [PriceStateController::class, 'update']);
        Route::delete('/{id}',  [PriceStateController::class, 'destroy']);
    });

    Route::prefix('price/country')->group(function () {
        Route::get('/active',  [PriceCountryController::class, 'activePriceCountry']);
        // Getting data
      
        Route::post('/',  [PriceCountryController::class, 'store']);
        Route::get('/',  [PriceCountryController::class, 'index']);
        Route::get('/{id}',  [PriceCountryController::class, 'show']);
        Route::put('/{id}',  [PriceCountryController::class, 'update']);
        Route::delete('/{id}',  [PriceCountryController::class, 'destroy']);
    });

    Route::prefix('price/product')->group(function () {
        Route::get('/active',  [PriceProductController::class, 'activePriceProduct']);
        // Getting data
      
        Route::post('/',  [PriceProductController::class, 'store']);
        Route::get('/',  [PriceProductController::class, 'index']);
        Route::get('/{id}',  [PriceProductController::class, 'show']);
        Route::put('/{id}',  [PriceProductController::class, 'update']);
        Route::delete('/{id}',  [PriceProductController::class, 'destroy']);
    });


});









Route::group(['prefix' => 'v1/backend', 'middleware' => ['auth:sanctum']], function () {

    Route::prefix('post')->group(function () {
        //Route::get('/active',  [PostController::class, 'activeProduct']);
        
        // CRUD operations
        Route::post('/',  [PostController::class, 'store']);
        Route::get('/',  [PostController::class, 'index']);
        Route::get('/{id}',  [PostController::class, 'show']);
        Route::put('/{id}',  [PostController::class, 'update']);
        Route::delete('/{id}',  [PostController::class, 'destroy']);
    });






    // Logout
    Route::get('/logout',  [ManagerAuthenticationController::class, 'logout']);

    Route::get('/customer/logout',  [CustomerAuthenticationController::class, 'logout']);




    Route::get('/user', function (Request $request) {
        return $request->user();
    });



    // Media Upload
    Route::prefix('media')->group(function () {

        // Other oprateions
        Route::post('/selected',  [MediaController::class, 'selectedImage']);

        // CRUD operations
        Route::get('/',  [MediaController::class, 'index']);
        Route::post('/',  [MediaController::class, 'upload']);
        Route::get('/{id}',  [MediaController::class, 'show']);
        Route::delete('/{id}',  [MediaController::class, 'delete']);
    });

    // Product
    Route::prefix('product')->group(function () {
        Route::get('/active',  [ProductController::class, 'activeProduct']);
        
        // CRUD operations
        Route::post('/',  [ProductController::class, 'store']);
        Route::get('/',  [ProductController::class, 'index']);
        Route::get('/{id}',  [ProductController::class, 'show']);
        Route::put('/{id}',  [ProductController::class, 'update']);
        Route::delete('/{id}',  [ProductController::class, 'destroy']);
    });

    // Product Group
    Route::prefix('group')->group(function () {

        // CRUD operations
        Route::post('/',  [ProductGroupController::class, 'store']);
        Route::get('/',  [ProductGroupController::class, 'index']);
        Route::get('/{id}',  [ProductGroupController::class, 'show']);
        Route::put('/{id}',  [ProductGroupController::class, 'update']);
        Route::delete('/{id}',  [ProductGroupController::class, 'destroy']);
     });

    // Specifications
    Route::prefix('specification')->group(function () {

        // CRUD operations
        Route::post('/',  [SpecificationController::class, 'store']);
        Route::get('/',  [SpecificationController::class, 'index']);
        Route::get('/{id}',  [SpecificationController::class, 'show']);
        Route::put('/{id}',  [SpecificationController::class, 'update']);
        Route::delete('/{id}',  [SpecificationController::class, 'destroy']);
    });


    // Attribute
    Route::prefix('attribute')->group(function () {
        //other Opreation
        Route::get('/active',  [AttributeController::class, 'activeAttribute']);

         // CRUD operations
        Route::post('/',  [AttributeController::class, 'store']);
        Route::get('/',  [AttributeController::class, 'index']);
        Route::get('/{id}',  [AttributeController::class, 'show']);
        Route::put('/{id}',  [AttributeController::class, 'update']);
        Route::delete('/{id}',  [AttributeController::class, 'destroy']);

    });

    // Grade
    Route::prefix('grade')->group(function () {

        //other Opreation
        Route::get('/active',  [GradeController::class, 'activeGrade']);
        
        // CRUD operations
       Route::post('/',  [GradeController::class, 'store']);
       Route::get('/',  [GradeController::class, 'index']);
       Route::get('/{id}',  [GradeController::class, 'show']);
       Route::put('/{id}',  [GradeController::class, 'update']);
       Route::delete('/{id}',  [GradeController::class, 'destroy']);

   });


    // Category
    Route::prefix('category')->group(function () {
        // Other operations
        Route::get('/parent', [CategoryController::class, 'parent']);
        Route::get('/product/{id}', [CategoryController::class, 'productCategory']);

        // CRUD operations
        Route::post('/', [CategoryController::class, 'store']);
        Route::get('/', [CategoryController::class, 'index']);
        Route::get('/{id}', [CategoryController::class, 'show']);
        Route::put('/{id}', [CategoryController::class, 'update']);
        Route::delete('/{id}', [CategoryController::class, 'destroy']);
        
        
    });

    // Advertisement
    Route::prefix('advertisement')->group(function () {
        // Other operations

        // CRUD operations 
        Route::post('/',  [AdvertisementController::class, 'store']);
        Route::get('/',  [AdvertisementController::class, 'index']);
        Route::get('/{id}',  [AdvertisementController::class, 'show']);
        Route::put('/{id}',  [AdvertisementController::class, 'update']);
        Route::delete('/{id}',  [AdvertisementController::class, 'destroy']);
    });


    // Subscription
    Route::prefix('subscription')->group(function () {
        // Other operations

        // CRUD operations 
        Route::post('/',  [SubscriptionController::class, 'store']);
        Route::get('/',  [SubscriptionController::class, 'index']);
        Route::get('/{id}',  [SubscriptionController::class, 'show']);
        Route::put('/{id}',  [SubscriptionController::class, 'update']);
        Route::delete('/{id}',  [SubscriptionController::class, 'destroy']);
    });

    // Daily update category
    Route::prefix('dailyupdates/category')->group(function () {
        // Other operations
        Route::get('/active',  [DailyUpdateCategoryController::class, 'activeCategory']);
        
        // CRUD operations 
        Route::post('/',  [DailyUpdateCategoryController::class, 'store']);
        Route::get('/',  [DailyUpdateCategoryController::class, 'index']);
        Route::get('/{id}',  [DailyUpdateCategoryController::class, 'show']);
        Route::put('/{id}',  [DailyUpdateCategoryController::class, 'update']);
        Route::delete('/{id}',  [DailyUpdateCategoryController::class, 'destroy']);
    });

     // Daily Update
     Route::prefix('dailyupdate')->group(function () {
        // Other operations

        // CRUD operations 
        Route::post('/',  [DailyUpdateController::class, 'store']);
        Route::get('/',  [DailyUpdateController::class, 'index']);
        Route::get('/{id}',  [DailyUpdateController::class, 'show']);
        Route::put('/{id}',  [DailyUpdateController::class, 'update']);
        Route::delete('/{id}',  [DailyUpdateController::class, 'destroy']);
    });

     // Article
     Route::prefix('article')->group(function () {
        // Other operations
        Route::post('/public',  [ArticleController::class, 'publishArticle']);

        // CRUD operations 
        Route::post('/',  [ArticleController::class, 'store']);
        Route::get('/',  [ArticleController::class, 'index']);
        Route::get('/{id}',  [ArticleController::class, 'show']);
        Route::put('/{id}',  [ArticleController::class, 'update']);
        Route::delete('/{id}',  [ArticleController::class, 'destroy']);
    });

     


    // Manager
    Route::prefix('manager')->group(function () {
        // Other operations
        Route::post('/profile-pic',  [ManagerController::class, 'profilePic']);
        Route::put('role/{id}',  [ManagerController::class, 'roleUpdate']);

        // CRUD operations
        Route::post('/',  [ManagerController::class, 'store']);
        Route::get('/',  [ManagerController::class, 'index']);
        Route::get('/{id}',  [ManagerController::class, 'show']);
        Route::put('/{id}',  [ManagerController::class, 'update']);
        Route::delete('/{id}',  [ManagerController::class, 'destroy']);
    });


    // Roles and permission
    Route::prefix('role')->group(function () {
        // Other operations
        Route::get('/active',  [RoleController::class, 'activeRole']);

        // CRUD operations
        Route::post('/',  [RoleController::class, 'store']);
        Route::get('/',  [RoleController::class, 'index']);
        Route::get('/{id}',  [RoleController::class, 'show']);
        Route::put('/{id}',  [RoleController::class, 'update']);
        Route::delete('/{id}',  [RoleController::class, 'destroy']);
    });

    // Customer
    Route::prefix('customer')->group(function () {
        // Other operations
        Route::post('/profile-pic',  [CustomerController::class, 'profilePic']);
        Route::post('/cover-pic',  [CustomerController::class, 'coverPic']);
        Route::get('/profile',  [CustomerController::class, 'showProfile']);
        Route::put('/profile',  [CustomerController::class, 'updateProfile']);
        

        // CRUD operations
        Route::post('/',  [CustomerController::class, 'store']);
        Route::get('/',  [CustomerController::class, 'index']);
        Route::get('/{id}',  [CustomerController::class, 'show']);
        Route::put('/{id}',  [CustomerController::class, 'update']);
        Route::delete('/{id}',  [CustomerController::class, 'destroy']);

    });


    // Customer Type
    Route::prefix('customer-type')->group(function () {

        // CRUD operations
        Route::post('/',  [CustomerTypeController::class, 'store']);
        Route::get('/',  [CustomerTypeController::class, 'index']);
        Route::get('/{id}',  [CustomerTypeController::class, 'show']);
        Route::put('/{id}',  [CustomerTypeController::class, 'update']);
        Route::delete('/{id}',  [CustomerTypeController::class, 'destroy']);
    });


    // Customer side data


    // Product
    /*Route::prefix('post')->group(function () {
        //Route::get('/active',  [PostController::class, 'activeProduct']);
        
        // CRUD operations
        Route::post('/',  [PostController::class, 'store']);
        Route::get('/',  [PostController::class, 'index']);
        Route::get('/{id}',  [PostController::class, 'show']);
        Route::put('/{id}',  [PostController::class, 'update']);
        Route::delete('/{id}',  [PostController::class, 'destroy']);
    });*/

    Route::prefix('city')->group(function () {

        // Getting data
      
        Route::get('/', [CityController::class, 'index']);
    });




    Route::prefix('price/city')->group(function () {
        Route::get('/active/{id}',  [PriceCityController::class, 'activePriceCity']);
        // Getting data
      
        Route::post('/',  [PriceCityController::class, 'store']);
        Route::get('/',  [PriceCityController::class, 'index']);
        Route::get('/{id}',  [PriceCityController::class, 'show']);
        Route::put('/{id}',  [PriceCityController::class, 'update']);
        Route::delete('/{id}',  [PriceCityController::class, 'destroy']);
    });


    Route::prefix('price/state')->group(function () {
        Route::get('/active/{id}',  [PriceStateController::class, 'activePriceState']);
        // Getting data
      
        Route::post('/',  [PriceStateController::class, 'store']);
        Route::get('/',  [PriceStateController::class, 'index']);
        Route::get('/{id}',  [PriceStateController::class, 'show']);
        Route::put('/{id}',  [PriceStateController::class, 'update']);
        Route::delete('/{id}',  [PriceStateController::class, 'destroy']);
    });

    Route::prefix('price/country')->group(function () {
        Route::get('/active',  [PriceCountryController::class, 'activePriceCountry']);
        // Getting data
      
        Route::post('/',  [PriceCountryController::class, 'store']);
        Route::get('/',  [PriceCountryController::class, 'index']);
        Route::get('/{id}',  [PriceCountryController::class, 'show']);
        Route::put('/{id}',  [PriceCountryController::class, 'update']);
        Route::delete('/{id}',  [PriceCountryController::class, 'destroy']);
    });

    Route::prefix('price/product')->group(function () {
        Route::get('/active',  [PriceProductController::class, 'activePriceProduct']);
        // Getting data
      
        Route::post('/',  [PriceProductController::class, 'store']);
        Route::get('/',  [PriceProductController::class, 'index']);
        Route::get('/{id}',  [PriceProductController::class, 'show']);
        Route::put('/{id}',  [PriceProductController::class, 'update']);
        Route::delete('/{id}',  [PriceProductController::class, 'destroy']);
    });


    Route::prefix('price')->group(function () {
        Route::get('/today',  [PriceController::class, 'todayPrice']);
        Route::get('/single',  [PriceController::class, 'getpriceProductCity']);
        
       // Route::get('/active',  [PriceCityController::class, 'activePriceCity']);

        // Getting data
      
        Route::post('/',  [PriceController::class, 'store']);
        Route::get('/',  [PriceController::class, 'index']);
        Route::get('/{id}',  [PriceController::class, 'show']);
        Route::put('/{id}',  [PriceController::class, 'update']);
        Route::delete('/{id}',  [PriceController::class, 'destroy']);
    });


    














});




/*Route::middleware('auth:sanctum')->group(function () {
Route::post('/login',  [UserController::class, 'login']);
Route::post('/organization/login',  [OrganizationController::class, 'login']);
}*/